//
//  YHTravelDocsPreparationListViewController.swift
//  galaxy
//
//  Created by davidhuangA on 2024/8/26.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

/*
 旅行证件准备
 */

class YHTravelDocsPreparationListViewController: YHBaseViewController {
    var orderId: Int = 0
    lazy var viewModel: YHTravelDocsPreparationViewModel = {
        let vm = YHTravelDocsPreparationViewModel()
        return vm
    }()

    lazy var tableView: UITableView = {
        let tableView = UITableView(frame:.zero, style:.grouped)
        tableView.estimatedSectionHeaderHeight = 16.0
        tableView.estimatedSectionFooterHeight = 0.01
        tableView.contentInsetAdjustmentBehavior = .never
        tableView.showsVerticalScrollIndicator = false
        tableView.separatorStyle = .none
        tableView.delegate = self
        tableView.dataSource = self
        tableView.backgroundColor = .clear
        tableView.register(UITableViewCell.self, forCellReuseIdentifier: "UITableViewCell")
        tableView.register(YHTravelDocsPreparationListCell.self, forCellReuseIdentifier: YHTravelDocsPreparationListCell.cellReuseIdentifier)
        
        tableView.register(YHTravelDocsPreparationTipsCell.self, forCellReuseIdentifier: YHTravelDocsPreparationTipsCell.cellReuseIdentifier)
        
        
        
        return tableView
    }()

    override func viewDidLoad() {
        super.viewDidLoad()
        setupUI()
    }
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        loadData()
    }
}

private extension YHTravelDocsPreparationListViewController {
    func loadData() {
        let params: [String : Any] = ["order_id": orderId]
        YHHUD.show(.progress(message: "加载中..."))
        viewModel.getTravelDocsList(param: params){ success, error in
            YHHUD.hide()
            if success {
                
            } else {
                let msg = error?.errorMsg ?? "获取数据出错"
                YHHUD.flash(message: msg)
                DispatchQueue.main.asyncAfter(deadline: .now() + 0.5) {
                    self.navigationController?.popViewController()
                }
            }
            self.tableView.reloadData()
        }
    }
    
   
    
    
    func setupUI() {
        gk_navTitle = "旅行证件准备"
        gk_navBarAlpha = 1.0
        gk_navBackgroundColor = .white
        view.backgroundColor = UIColor.contentBkgColor
        
        if orderId == 0 {
            if let id = UserDefaults.standard.value(forKey: "orderIdForPreview") {
                self.orderId = (id as? Int) ?? 0
            }
        }

        view.addSubview(tableView)
        tableView.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(kMargin)
            make.right.equalToSuperview().offset(-kMargin)
            make.top.equalTo(k_Height_NavigationtBarAndStatuBar)
            make.bottom.equalToSuperview()
        }
    }
}


extension YHTravelDocsPreparationListViewController: UITableViewDelegate, UITableViewDataSource {
    
    func numberOfSections(in tableView: UITableView) -> Int {
        return viewModel.arrTravelDocs.count > 0 ? viewModel.arrTravelDocs.count + 1 : 0
    }
    
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return 1
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        
        if viewModel.arrTravelDocs.count > 0 ,indexPath.section == viewModel.arrTravelDocs.count {
            let approveCell = tableView.dequeueReusableCell(withIdentifier: YHTravelDocsPreparationTipsCell.cellReuseIdentifier, for: indexPath)
            return approveCell
        } else if viewModel.arrTravelDocs.count > 0 ,indexPath.section < viewModel.arrTravelDocs.count {
            
            let approveCell = tableView.dequeueReusableCell(withIdentifier: YHTravelDocsPreparationListCell.cellReuseIdentifier, for: indexPath) as! YHTravelDocsPreparationListCell
            approveCell.dataModel = viewModel.arrTravelDocs[indexPath.section]
            return approveCell
        }
            
        let approveCell = tableView.dequeueReusableCell(withIdentifier: YHTravelDocsPreparationListCell.cellReuseIdentifier, for: indexPath)
        return approveCell
        
    }
    
    func tableView(_ tableView: UITableView, heightForRowAt indexPath: IndexPath) -> CGFloat {
        
        if viewModel.arrTravelDocs.count > 0 ,indexPath.section == viewModel.arrTravelDocs.count {
            return YHTravelDocsPreparationTipsCell.cellH
        }
        
        return YHTravelDocsPreparationListCell.cellH
    }
    
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        
        if 0 <= indexPath.section && indexPath.section < viewModel.arrTravelDocs.count {
            
            if let model = viewModel.arrTravelDocs[indexPath.section] {
                if model.status == -1 {
                    return
                } else {
                    let vc = YHTravelDocsPreparationDetailVC()
                    vc.dataModel = model
                    vc.orderId = orderId
                    self.navigationController?.pushViewController(vc)
                }
            }
        }
    }
    
    private func tableView(_ tableView: UITableView, viewForHeaderInSection section: Int) -> CGFloat {
        return 16.0
    }
    
    private func tableView(_ tableView: UITableView, viewForFooterInSection section: Int) -> CGFloat {
        return 0.01
    }
    
    func tableView(_ tableView: UITableView, viewForHeaderInSection section: Int) -> UIView? {
        
        let view = UIView()
        return view
    }
    
    func tableView(_ tableView: UITableView, viewForFooterInSection section: Int) -> UIView? {
        
        let view = UIView()
        return view
    }
}
